/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.autoplot.AutoplotUI;
import org.autoplot.OperationsPanel;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.PlotElement;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class DataPanel
extends JPanel {
    private final Application dom;
    private final AutoplotUI app;
    private final ApplicationController applicationController;
    private DataSourceFilter dsf;
    private BindingGroup dataSourceFilterBindingGroup;
    private boolean dataSourceFilterBindingGroupIsBound = false;
    private BindingGroup plotElementBindingGroup;
    private boolean plotElementBindingGroupIsBound = false;
    private PlotElement plotElement;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui.data");
    protected boolean adjusting = false;
    public static final String PROP_ADJUSTING = "adjusting";
    private final transient PropertyChangeListener contextListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataPanel.this.updateProcessDataSetLabel();
        }
    };
    private final transient PropertyChangeListener filtersListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (DataPanel.this.dsf.getFilters().trim().length() > 0) {
                DataPanel.this.additionalOperationsCheckBox.setSelected(true);
            }
        }
    };
    private final transient PropertyChangeListener fillDataSetListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            final QDataSet ds = (QDataSet)evt.getNewValue();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    DataPanel.this.plotElementFiltersPanel.setDataSet(ds);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    };
    private JCheckBox additionalOperationsCheckBox;
    private DataSetSelector dataSetSelector;
    private OperationsPanel dataSourceFiltersPanel;
    private JCheckBox doSuppressReset;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSplitPane jSplitPane1;
    private OperationsPanel plotElementFiltersPanel;
    private JLabel processDataSetLabel;
    private JCheckBox sliceAutorangesCB;
    private BindingGroup bindingGroup;

    public DataPanel(AutoplotUI app) {
        this.initComponents();
        this.plotElementFiltersPanel.setName("postOperationsPanel");
        this.dataSourceFiltersPanel.setName("operationsPanel");
        this.app = app;
        this.dom = app.getDom();
        this.applicationController = this.dom.getController();
        this.applicationController.addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        DataPanel.this.doPlotElementBindings();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            }
        });
        this.applicationController.addPropertyChangeListener("dataSourceFilter", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        DataPanel.this.doDataSourceFilterBindings();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            }
        });
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this.jPanel1, "dataPanel");
        this.plotElementFiltersPanel.setFilter("");
        this.doBindings();
        this.dataSetSelector.setPlayButton(false);
        this.dataSourceFiltersPanel.setVisible(false);
        this.jLabel2.setVisible(false);
    }

    protected void setExpertMode(boolean expert) {
        this.plotElementFiltersPanel.setExpertMode(expert);
        this.dataSourceFiltersPanel.setExpertMode(expert);
        this.dataSetSelector.setEnabled(expert);
        this.dataSourceFiltersPanel.setEnabled(expert);
        this.additionalOperationsCheckBox.setEnabled(expert);
        this.doSuppressReset.setEnabled(expert);
    }

    private PlotElement getElement() {
        return this.plotElement;
    }

    private static void assertEventThread(String caller) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException(caller + " must be called from the event thread.");
        }
    }

    protected final void doBindings() {
        logger.fine("doBindings");
        this.doPlotElementBindings();
        this.doDataSourceFilterBindings();
    }

    @Override
    public void paint(Graphics g) {
        if (!this.dataSourceFilterBindingGroupIsBound) {
            this.dataSourceFilterBindingGroup.bind();
            this.dataSourceFilterBindingGroupIsBound = true;
        }
        if (!this.plotElementBindingGroupIsBound) {
            this.plotElementBindingGroup.bind();
            this.plotElementBindingGroupIsBound = true;
        }
        super.paint(g);
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void setAdjusting(boolean adjusting) {
        boolean oldAdjusting = this.adjusting;
        this.adjusting = adjusting;
        this.firePropertyChange(PROP_ADJUSTING, oldAdjusting, adjusting);
    }

    private void updateProcessDataSetLabel() {
        PlotElement lelement = this.getElement();
        if (lelement != null) {
            QDataSet proc;
            DataSourceFilter dsf1 = this.dom.getController().getDataSourceFilterFor(lelement);
            QDataSet orig = dsf1 == null ? null : dsf1.getController().getFillDataSet();
            if (orig == (proc = lelement.getController().getDataSet()) || proc == null) {
                this.processDataSetLabel.setText("");
            } else {
                String lbl = String.valueOf(proc);
                QDataSet ds = lelement.getController().getDataSet();
                String s = DataSetUtil.contextAsString((QDataSet)ds).trim();
                this.processDataSetLabel.setText("<html>These operations result in the dataset<br>" + lbl + (s.length() == 0 ? "" : "<br>@ " + s));
            }
        } else {
            this.processDataSetLabel.setText("");
        }
    }

    private void doPlotElementBindings() {
        PlotElement p;
        DataPanel.assertEventThread("doPlotElementBindings");
        BindingGroup bc = new BindingGroup();
        if (this.plotElementBindingGroup != null) {
            this.plotElementBindingGroup.unbind();
        }
        this.setAdjusting(true);
        if (this.plotElement != null) {
            this.plotElement.getController().removePropertyChangeListener("dataSet", this.contextListener);
        }
        this.plotElement = p = this.applicationController.getPlotElement();
        if (p != null) {
            this.plotElementFiltersPanel.setFilter(p.getComponent());
        } else {
            this.plotElementFiltersPanel.setFilter("");
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (DataPanel.this.plotElement != null) {
                    DataPanel.this.plotElementFiltersPanel.setFilter(DataPanel.this.plotElement.getComponent());
                } else {
                    DataPanel.this.plotElementFiltersPanel.setFilter("");
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        if (this.plotElement != null) {
            bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.plotElement, (Property)BeanProperty.create((String)"component"), (Object)this.plotElementFiltersPanel, (Property)BeanProperty.create((String)"filter")));
            bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.plotElement.getController(), (Property)BeanProperty.create((String)"sliceAutoranges"), (Object)this.sliceAutorangesCB, (Property)BeanProperty.create((String)"selected")));
        }
        this.plotElementBindingGroup = bc;
        this.plotElementBindingGroupIsBound = false;
        this.setAdjusting(false);
        if (p != null) {
            p.getController().addPropertyChangeListener("dataSet", this.contextListener);
        }
        this.updateProcessDataSetLabel();
        this.repaint();
    }

    private void doDataSourceFilterBindings() {
        DataSourceFilter newDsf;
        DataPanel.assertEventThread("doDataSourceFilterBindings");
        if (this.dataSourceFilterBindingGroup != null) {
            this.dataSourceFilterBindingGroup.unbind();
        }
        if (this.dsf != null) {
            this.dsf.getController().removePropertyChangeListener("fillDataSet", this.fillDataSetListener);
            this.dsf.removePropertyChangeListener("filters", this.filtersListener);
        }
        if ((newDsf = this.applicationController.getDataSourceFilter()) == null) {
            this.dataSourceFilterBindingGroup = null;
            return;
        }
        QDataSet ds = newDsf.getController().getFillDataSet();
        newDsf.getController().addPropertyChangeListener("fillDataSet", this.fillDataSetListener);
        newDsf.addPropertyChangeListener("filters", this.filtersListener);
        this.additionalOperationsCheckBox.setSelected(newDsf.getFilters().trim().length() > 0);
        this.dataSourceFiltersPanel.setFilter(newDsf.getFilters());
        this.dataSourceFiltersPanel.setDataSet(newDsf.getController().getDataSet());
        this.plotElementFiltersPanel.setDataSet(ds);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)newDsf, (Property)BeanProperty.create((String)"filters"), (Object)this.dataSourceFiltersPanel, (Property)BeanProperty.create((String)"filter")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)newDsf, (Property)BeanProperty.create((String)"uri"), (Object)this.dataSetSelector, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)newDsf, (Property)BeanProperty.create((String)"controller.dataSet"), (Object)this.dataSourceFiltersPanel, (Property)BeanProperty.create((String)"dataSet")));
        this.dataSourceFilterBindingGroup = bc;
        this.dataSourceFilterBindingGroupIsBound = false;
        this.dsf = newDsf;
        this.repaint();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.dataSetSelector = new DataSetSelector();
        this.dataSourceFiltersPanel = new OperationsPanel();
        this.additionalOperationsCheckBox = new JCheckBox();
        this.doSuppressReset = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.sliceAutorangesCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.processDataSetLabel = new JLabel();
        this.plotElementFiltersPanel = new OperationsPanel();
        this.setName("dataPanel");
        this.jSplitPane1.setDividerLocation(110);
        this.jSplitPane1.setOrientation(0);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Data Source [?]"));
        this.jPanel1.setName("dataSourcePanel");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont((float)this.jLabel2.getFont().getSize() - 4.0f));
        this.jLabel2.setText("Apply these operations to the data after loading.  Fill and valid range can be specified with putProperty filter.");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.additionalOperationsCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.jLabel2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.dataSetSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.dataSetSelectorActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.additionalOperationsCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.dataSourceFiltersPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.additionalOperationsCheckBox.setSelected(false);
        this.additionalOperationsCheckBox.setText("Apply additional operations immediately after data is loaded");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dataSourceFiltersPanel, (Property)ELProperty.create((String)"${visible}"), (Object)this.additionalOperationsCheckBox, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.additionalOperationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPanel.this.additionalOperationsCheckBoxActionPerformed(evt);
            }
        });
        this.doSuppressReset.setSelected(true);
        this.doSuppressReset.setText("Suppress Reset");
        this.doSuppressReset.setToolTipText("Normally the play button would reset the axis ranges and plot style, but this suppresses this behavior.");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.dataSetSelector, -1, 578, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.additionalOperationsCheckBox).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.doSuppressReset)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE).add((Component)this.dataSourceFiltersPanel, -2, 0, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.dataSetSelector, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.additionalOperationsCheckBox).add((Component)this.doSuppressReset)).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.dataSourceFiltersPanel, -2, 0, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel1.getAccessibleContext().setAccessibleName("Data Source and Initial Processing [?]");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Data Post Processing [?]\n"));
        this.jPanel2.setName("dataPostProcessingPanel");
        this.sliceAutorangesCB.setText("Autorange after operations");
        this.sliceAutorangesCB.setToolTipText("Changing the slice index will re-autorange the data");
        this.sliceAutorangesCB.setName("sliceAutorangesCB");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() - 4.0f));
        this.jLabel1.setText("Apply additional operations to the dataset before plotting");
        this.jLabel1.setName("DataPostProcessingInstructionsLabel");
        this.processDataSetLabel.setFont(this.processDataSetLabel.getFont().deriveFont((float)this.processDataSetLabel.getFont().getSize() - 4.0f));
        this.processDataSetLabel.setText("(filtered dataset will go here)");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add((Component)this.sliceAutorangesCB, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.plotElementFiltersPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.processDataSetLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.plotElementFiltersPanel, -1, 197, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.sliceAutorangesCB).addPreferredGap(0).add((Component)this.processDataSetLabel).add(16, 16, 16)));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSplitPane1).add(0, 0, 0)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1));
        this.bindingGroup.bind();
    }

    private void dataSetSelectorActionPerformed(ActionEvent evt) {
        final String uri = this.dataSetSelector.getValue();
        int modifiers = evt.getModifiers();
        boolean suppressReset = this.doSuppressReset.isSelected();
        if (suppressReset) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ((DataPanel)DataPanel.this).app.dom.getController().plotUri(uri, false);
                }
            };
            new Thread(run, "plotUri").start();
        } else {
            this.app.doPlotGoButton(uri, modifiers);
        }
    }

    private void additionalOperationsCheckBoxActionPerformed(ActionEvent evt) {
        this.dataSourceFiltersPanel.setVisible(this.additionalOperationsCheckBox.isSelected());
        this.jLabel2.setVisible(this.additionalOperationsCheckBox.isSelected());
        if (!this.additionalOperationsCheckBox.isSelected()) {
            this.dsf.setFilters("");
        }
    }
}

